package cn.com.duiba.kjy.livecenter.api.enums.conf;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@Getter
public enum LaunchLocationEnum {
    STUDIO_LEFT(1, "直播间左侧"),
    ;


    private Integer type;

    private String desc;

    LaunchLocationEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private static final Map<Integer, LaunchLocationEnum> ENUM_MAP = new HashMap<>();


    static {
        for (LaunchLocationEnum linkToType : values()) {
            ENUM_MAP.put(linkToType.getType(), linkToType);
        }
    }

    public static LaunchLocationEnum getByType(Integer key) {
        if (key == null) {
            return null;
        }
        return ENUM_MAP.get(key);
    }

    /**
     * 是否包含
     *
     * @param key
     * @return
     */
    public static boolean contains(Integer key) {
        if (null == key) {
            return false;
        }
        for (LaunchLocationEnum enumVal : LaunchLocationEnum.values()) {
            if (Objects.equals(enumVal.getType(), key)) {
                return true;
            }
        }
        return false;
    }
}
