package cn.com.duiba.kjy.livecenter.api.enums.risk;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * Created by hong
 * time 2021/11/8.
 */
@Getter
public enum RiskTypeEnum {

    REPEATED_WINS(1, "repeatedWins", "重复中奖风控"),
    RISK_CONTROL_HIT(2, "riskControlHit", "钟馗风控系统命中"),
    PERMANENT_RISK_CONTROL(3, "permanentRiskControl", "永久风控用户"),
    WECHAT_RISK(4,"wechatRiskCtrl","微信风控")
    ;

    private final Integer code;

    private final String  type;

    private final String  desc;

    RiskTypeEnum(Integer code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public static RiskTypeEnum getByCode(Integer code) {
        return Stream.of(RiskTypeEnum.values())
                     .filter(e -> e.getCode()
                                   .equals(code))
                     .findFirst()
                     .orElse(REPEATED_WINS);
    }

    public static RiskTypeEnum getByType(String type) {
        return Stream.of(RiskTypeEnum.values())
                     .filter(e -> e.getType()
                                   .equals(type))
                     .findFirst()
                     .orElse(REPEATED_WINS);
    }
}
