package cn.com.duiba.kjy.livecenter.api.remoteservice.company;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.company.video.LiveCompanyVideoLikeRecordDto;

import java.util.Map;
import java.util.Set;

/**
 * @author liuchao1
 * @version 1.0
 * @date 2020-09-27 17:19
 */
@AdvancedFeignClient
public interface RemoteLiveCompanyVideoLikeRecordService {

    /**
     * 根据访客id和视频id查询点赞记录
     * @param liveVisitorId 访客id
     * @param videoId 视频id
     * @return 点赞记录
     */
    LiveCompanyVideoLikeRecordDto findByVisitorIdAndVideoId(Long liveVisitorId, Long videoId);

    /**
     * 查询访客点赞状态
     * @param liveVisitorId 访客直播用户id
     * @param videoIds 视频id集合
     * @return key：视频id value：点赞状态
     */
    Map<Long, Integer> getVisitorState(Long liveVisitorId, Set<Long> videoIds);
}
