package cn.com.duiba.kjy.livecenter.api.remoteservice.invitation;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.invitation.CommunityInvitationDto;
import cn.com.duiba.kjy.livecenter.api.param.invitation.CommunityInvitationSearchParam;
import java.util.List;

/**
 * 社群邀约关系
 * @author ouyang
 * @date 2022-05-26
 */
@AdvancedFeignClient
public interface RemoteCommunityInvitationService {

    /**
     * 查询列表
     * @param param 查询条件
     * @return 查询结果
     */
    List<CommunityInvitationDto> selectList(CommunityInvitationSearchParam param);


    /**
     * 查询数量
     * @param param 查询条件
     * @return 符合条件的数量
     */
    Long selectCount(CommunityInvitationSearchParam param);

    /**
     * 根据ID查询
     * @param id 主键
     * @return
     */
    CommunityInvitationDto selectById(Long id);

    /**
     * 新增绑定关系
     * @param dto 新增关系数据
     * @return 插入条数
     */
    int insert(CommunityInvitationDto dto);

    /**
     * 更新绑定关系 id
     * @param dto dto
     * @return 条数
     */
    int update(CommunityInvitationDto dto);

    /**
     * 删除绑定关系
     * @param id 关系ID
     * @return 删除数量
     */
    int delete(Long id);


    int batchInsert(List<CommunityInvitationDto> dtoList);


    /**
     * 确定邀约关系
     * @param companyId 公司Id
     * @param bizSource 业务来源
     * @param liveUserId 用户Id
     * @return 结果
     */
    int updateInvitationStatusConfirm(Long companyId, String bizSource,Long drainageId, Long liveUserId);

}
