package cn.com.duiba.kjy.livecenter.api.dto.black;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 直播黑名单源头用户表
 * @author kjj mybatis generator 
 * @date 2020-09-27
 */
@Data
public class LiveBlackSourceDto implements Serializable {
     
    private static final long serialVersionUID = 16011888162466107L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播用户id
     */
    private Long liveUserId;

    /**
     * 黑名单用户来源类型 1:访客 2:代理人
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.blackList.SourceTypeEnum
     */
    private Integer sourceType;

    /**
     * 备注
     */
    private String remark;

    /**
     * 封禁人数
     */
    private Integer banNum;

    /**
     * 直播间id
     */
    private Long liveId;

    /**
     * 访客邀请链路
     */
    private String invitorIds;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}