package cn.com.duiba.kjy.livecenter.api.enums.live;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.ArrayList;
import java.util.List;

/**
 * 外链类型枚举
 *
 * @author xuzhigang
 * @date 2020/7/16 14:08
 **/
@Getter
@AllArgsConstructor
public enum OutLinkTypeEnum {

    CUSTOMER_SERVICE_MESSAGE(1, "客服消息"),
    H5_LINK(2, "H5链接"),
    MINI_PROGRAMS(3, "小程序"),
    //信息存在extInfo中
    WEI_DIAN(4, "微店"),
    ENTER_CREDIT(5,"办卡链接id"),
    USER_RECEIVING_ADDRESS(6,"用户收货地址")
    ;

    /**
     * 扩展信息LinkType
     */
    public static final List<Integer> EXT_OUT_LINK_TYPE_ENUM =  new ArrayList<>();

    static {
        EXT_OUT_LINK_TYPE_ENUM.add(4);
        EXT_OUT_LINK_TYPE_ENUM.add(5);
        EXT_OUT_LINK_TYPE_ENUM.add(6);
    }

    /**
     * 类型
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;
}
