package cn.com.duiba.kjy.livecenter.api.remoteservice;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.subscribe.WxSubscribeMessageDto;

import java.util.List;

@AdvancedFeignClient
public interface RemoteWxSubscribeMessageService {

    /**
     * 保存
     * @param wxSubscribeMessageDto
     * @return
     */
    Integer save(WxSubscribeMessageDto wxSubscribeMessageDto);

    /**
     * 删除
     * @param id
     * @return
     */
    Integer deleteById(Long id);

    /**
     * 批量删除id
     * @param ids
     * @return
     */
    Integer deleteBatchByIds(List<Long> ids);

    /**
     * 更新
     * @param wxSubscribeMessageDto
     * @return
     */
    Integer updateById(WxSubscribeMessageDto wxSubscribeMessageDto);

    /**
     * 根据id查询
     * @param id
     * @return
     */
    WxSubscribeMessageDto getById(Long id);

    /**
     * 根据id集合批量查询
     * @param ids
     * @return
     */
    List<WxSubscribeMessageDto> listByIds(List<Long> ids);

    /**
     * 根据批量查询
     * @return
     */
    List<WxSubscribeMessageDto> list(WxSubscribeMessageDto wxSubscribeMessageDto);

    /**
     * 优惠券使用提醒保存
     * @param wxSubscribeMessageDto
     * @return
     */
    Integer saveCouponUsageReminder(WxSubscribeMessageDto wxSubscribeMessageDto);

}
