package cn.com.duiba.kjy.livecenter.api.remoteservice.community;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.community.LiveCommunityInterestsDto;
import cn.com.duiba.kjy.livecenter.api.param.community.CommunityInterestsSearchParam;
import java.util.List;

/**
 * 社群权益（公司或代理人指定权益）
 * @author ouyang
 * @date 2022/01/05
 */
@AdvancedFeignClient
public interface RemoteLiveCommunityInterestsService {

    /**
     * 新增/编辑
     * @param dto dto
     * @return true-成功 false-失败
     */
    boolean saveOrUpdate(LiveCommunityInterestsDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    boolean delete(Long id);

    /**
     * 主键查询
     * @param id 主键
     * @return dto
     */
    LiveCommunityInterestsDto selectById(Long id);

    /**
     * 查询列表
     * @param param 查询参数
     * @return dto
     */
    List<LiveCommunityInterestsDto> selectPageList(CommunityInterestsSearchParam param);

    /**
     * 查询数据条数
     * @param param 查询参数
     * @return count
     */
    Long selectCount(CommunityInterestsSearchParam param);



}
