package cn.com.duiba.kjy.livecenter.api.remoteservice.duiba;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.duiba.DuibaAppDto;
import cn.com.duiba.kjy.livecenter.api.param.duiba.DuibaAppSearchParam;

import java.util.List;

/**
 * @Author xujing
 * @Date 2021/12/21 3:32 下午
 */
@AdvancedFeignClient
public interface RemoteDuibaAppService {
    /**
     * 删除单条数据
     * @param id
     * @return
     */
    int deleteById(Long id);

    /**
     * 插入一条数据
     * @param record
     * @return
     */
    Long insert(DuibaAppDto record);

    /**
     * 查询一条数据
     * @param id
     * @return
     */
    DuibaAppDto selectById(Long id);

    /**
     * 更新一条数据
     * @param record
     * @return
     */
    int updateById(DuibaAppDto record);

    /**
     * 查询列表
     * @param param
     * @return
     */
    List<DuibaAppDto> listByParam(DuibaAppSearchParam param);

    /**
     * 查询全部
     * @return
     */
    List<DuibaAppDto> listAll();


    /**
     * 根据appKey 查询
     * @param appKey
     * @return
     */
    DuibaAppDto findByAppKey(String appKey);

}

