package cn.com.duiba.kjy.livecenter.api.dto.skin;

import cn.com.duiba.kjy.livecenter.api.enums.skin.SkinStatusEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 皮肤代码版本
 *
 * @Author xujing
 * @Date 2021/4/21 2:17 下午
 */
@Data
public class SkinCodeDto implements Serializable {

    private static final long serialVersionUID = 5382597439788904765L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 皮肤id
     */
    private Long skinId;

    /**
     * 代码版本
     */
    private String codeVersion;

    /**
     * 作者 上传人git邮箱
     */
    private String codeAuthor;

    /**
     * 代码字符串
     */
    private String codeStr;

    /**
     * @see SkinStatusEnum
     * 0 草稿 1上架版本 2历史版本
     */
    private Integer codeStatue;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 0 未删除 1已删除
     */
    private Integer deleted;
}