package cn.com.duiba.kjy.livecenter.api.enums.live.share;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 直播分享类型枚举
 *
 * @author xuzhigang
 * @date 2020/8/8 3:09 下午
 **/
@Getter
@AllArgsConstructor
public enum LiveShareTypeEnum {
    MP_SHARE(1, "普通小程序分享"),

    RED_MP_SHARE(2, "红包小程序分享"),

    PRE_LOTTERY_MP_SHARE(3, "直播前抽奖分享"),

    DOUBLE_RED_MP_SHARE(4, "翻倍红包小程序分享"),

    FLIP_WORD_MP_SHARE(5, "集卡活动小程序分享"),

    BLIND_BOX_SHARE(6, "盲盒裂变分享"),
    ;

    public static final Map<Integer, LiveShareTypeEnum> ALL_TYPE;

    static {
        ALL_TYPE = EnumSet.allOf(LiveShareTypeEnum.class).stream().collect(Collectors.toMap(LiveShareTypeEnum::getType, Function.identity()));
    }

    private Integer type;

    private String desc;

    /**
     * 校验是否是小程序分享
     *
     * @param shareType 分享类型
     * @return true-是小程序分享 false-不是小程序分享
     */
    public static boolean isMpShare(Integer shareType) {
        return ALL_TYPE.containsKey(shareType);
    }
}
