package cn.com.duiba.kjy.livecenter.api.param.live.share.coupon;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Author xujing
 * @Date 2021/12/16 11:29 上午
 */
@Data
public class LiveCouponSearchParams implements Serializable {

    private static final long serialVersionUID = -1677662088618777899L;

    /**
     * 主键
     */
    private Long id;

    private List<Long> ids;

    /**
     * 直播间id
     */
    private Long liveId;

    /**
     * 发放位置 1直播间 2预约页面
     *
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.coupon.CouponIssueLocationEnum
     */
    private Integer issueLocation;

    private List<Integer> issueLocations;
    /**
     * 1 进入直播间 2关注直播间
     *
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.coupon.CouponIssueUserEnum
     */
    private Integer issueUser;

    private List<Integer> issueUsers;
}
