package cn.com.duiba.kjy.livecenter.api.remoteservice.agent;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.agent.AgentAptaskDto;

import java.util.List;

/**
 *  代理人邀约任务
 * @author sunyan
 * @date 2020/10/30
 */
@AdvancedFeignClient
public interface RemoteAgentAptaskService {
    /**
     * 删除
     * @param id
     * @return
     */
    int delete(Long id);

    /**
     * 新增
     * @param agentAptaskDto
     * @return
     */
    int insert(AgentAptaskDto agentAptaskDto);

    /**
     *
     * 按id查询
     * @param id
     * @return
     */
    AgentAptaskDto selectById(Long id);

    /**
     * 按直播间查询
     * @param liveId
     * @return
     */
    AgentAptaskDto selectByLiveId(Long liveId);

    /**
     * 按直播间查询未删除任务
     * @param liveId
     * @return
     */
    AgentAptaskDto selectNotDelByLiveId(Long liveId);

    /**
     * 批量按直播间查询
     * @param liveIds
     * @return
     */
    List<AgentAptaskDto> selectNotDelByLiveIds(List<Long> liveIds);

    /**
     * 更新
     * @param agentAptaskDto
     * @return
     */
    int updateById(AgentAptaskDto agentAptaskDto);
}
