package cn.com.duiba.kjy.livecenter.api.dto.conf;

import cn.com.duiba.kjy.livecenter.api.enums.conf.ApplyCardTypeEnum;
import cn.com.duiba.kjy.livecenter.api.enums.conf.ApplyCardWayEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 直播办卡配置
 * @Author xujing
 * @Date 2021/6/25 4:31 下午
 */
@Data
public class ApplyCardConfigDto implements Serializable {

    private static final long serialVersionUID = -8060933975165107724L;
    /**
     * id
     */
    private Long id;

    /**
     * 直播间id
     */
    private Long liveId;

    /**
     * @see ApplyCardTypeEnum
     * 类型 1:直播前必买清单 2:直播中必买清单 3:直播中办卡入口
     */
    private Integer applyCardType;

    /**
     * 办卡浮标
     */
    private String applyCardBuoy;

    /**
     * @see ApplyCardWayEnum
     * 办卡方式 1 h5 2小程序
     */
    private Integer applyCardWay;

    /**
     * 办卡链接地址
     */
    private String applyCardLink;

    /**
     * 办卡小程序id
     */
    private String applyCardAppId;

    /**
     * 办卡小程序地址
     */
    private String applyCardPath;

    /**
     * 办卡标题
     */
    private String applyCardTitle;
    /**
     * 办卡图标
     */
    private String applyCardIcon;
    /**
     * 办卡弹窗
     */
    private String applyCardPopup;
    /**
     * 弹窗状态 0:不弹 1:弹
     */
    private Integer popupState;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;


}