package cn.com.duiba.kjy.livecenter.api.dto.live.risk;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 
 * @author youqian mybatis generator 
 * 2021-10-13
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class LiveRiskListDto implements Serializable {
    private static final long serialVersionUID = 16340565987523581L;

    /**
     * 主键
     * not null default = null
     */
    private Long id;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 直播id
     * not null default = null
     */
    private Long liveId;

    /**
     * 用户id
     * not null default = null
     */
    private Long userId;

    /**
     * 公司id
     * not null default = null
     */
    private Long companyId;

    /**
     * 开始时间
     * not null default = null
     */
    private Date startTime;

    /**
     * 结束时间
     * not null default = null
     */
    private Date endTime;

    /**
     * 风控类型
     * not null default = null
     * @see cn.com.duiba.kjy.livecenter.api.enums.risk.RiskTypeEnum
     */
    private Integer riskType;
}