package cn.com.duiba.kjy.livecenter.api.param.liveResource;

import cn.com.duiba.kjy.livecenter.api.enums.DeletedEnum;
import cn.com.duiba.kjy.livecenter.api.param.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.List;

/**
 * 直播资料库
 * @author kjj mybatis generator
 * @date 2020-04-01
 */
@ToString(callSuper = true)
@Data
@EqualsAndHashCode(callSuper = true)
public class ResourceSearchParam extends PageQuery {

    private static final long serialVersionUID = 1585712211478801L;

    /**
     * 直播公司ID
     */
    private Long companyId;

    /**
     * 资料类型
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.LiveInteractTypeEnum
     */
    private Integer resourceType;

    /**
     * 资料类型 集合
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.LiveInteractTypeEnum
     */
    private List<Integer> resourceTypeList;

    /**
     * 排除的ID集合
     */
    private List<Long> excludeIdList;

    /**
     * ID集合
     */
    private List<Long> idList;

    /**
     * 是否删除，1=已删除，0=未删除
     * @see cn.com.duiba.kjy.livecenter.api.enums.DeletedEnum
     */
    private Integer deleted = DeletedEnum.NON_DELETED.getCode();

    /**
     * 资料名称筛选
     */
    private String title;

    /**
     * 资料ID
     */
    private Long id;

    /**
     * 营销类别
     */
    private List<Integer> marketTypes;
}
