package cn.com.duiba.kjy.livecenter.api.remoteservice.community;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.community.LiveCommunityDrainageDto;
import cn.com.duiba.kjy.livecenter.api.param.community.CommunityDrainageSearchParam;
import java.util.List;

/**
 * 社群引流模版
 * @author ouyang
 * @date 2022/01/05
 */
@AdvancedFeignClient
public interface RemoteLiveCommunityDrainageService {

    /**
     * 新增/编辑
     * @param dto dto
     * @return id
     */
    Long saveOrUpdate(LiveCommunityDrainageDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    boolean delete(Long id);

    /**
     * 主键查询
     * @param id 主键
     * @return dto
     */
    LiveCommunityDrainageDto selectById(Long id);

    /**
     * 查询列表
     * @param param 查询参数
     * @return dto
     */
    List<LiveCommunityDrainageDto> selectPageList(CommunityDrainageSearchParam param);

    /**
     * 查询数据条数
     * @param param 查询参数
     * @return count
     */
    Long selectCount(CommunityDrainageSearchParam param);



}
