package cn.com.duiba.kjy.livecenter.api.remoteservice.company;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.company.LiveCompanyMpDto;

import java.util.List;

/**
 * @author chengsiyi
 * @date 2021/2/5 16:08
 */
@AdvancedFeignClient
public interface RemoteLiveCompanyMpService {

    /**
     * 保存修改直播公司关联的小程序
     * @param dto
     * @return 修改的主键
     */
    Long saveOrUpdate(LiveCompanyMpDto dto);

    int updateAuthStatus(String mpWechatId, Integer authStatus);

    LiveCompanyMpDto getById(Long id);

    List<LiveCompanyMpDto> listByIds(List<Long> ids);

    /**
     * 查询授权给公司的小程序
     * @param companyId 直播公司ID
     * @return 授权小程序列表
     */
    List<LiveCompanyMpDto> findAuthMpByCompany(Long companyId);

    /**
     * 查询授权给公司的小程序
     * @param companyId 公司ID
     * @param authType {@link cn.com.duiba.kjy.livecenter.api.enums.company.AuthMpTypeEnum}授权类型
     * @return null if authType is null 授权小程序
     */
    LiveCompanyMpDto findAuthMpByCompanyAndType(Long companyId, Integer authType);

    /**
     * 获取所有的授权小程序
     * @param authType {@link cn.com.duiba.kjy.livecenter.api.enums.company.AuthMpTypeEnum}授权类型
     * @return authType null 返回所有授权的小程序
     */
    List<LiveCompanyMpDto> getAllAuthMp(Integer authType);


    /**
     * 获取所有绑定的公司
     */
    List<LiveCompanyMpDto> listByAppId(String appId);

    /**
     * 根据兑吧appId查询
     * @param duibaAppId
     * @return
     */
    Integer countByDuibaAppId(Long duibaAppId);
}
