package cn.com.duiba.kjy.livecenter.api.dto.liveResource;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 直播资料库
 * @author kjj mybatis generator
 * @date 2020-04-01
 */
@Data
public class ResourceDto implements Serializable {

    private static final long serialVersionUID = 15857122114778642L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播公司ID
     */
    private Long companyId;

    /**
     * 资源标题
     */
    private String resourceTitle;

    /**
     * 资源地址
     */
    private String resourceUrl;

    /**
     * 资料图片
     */
    private String resourceImg;

    /**
     * 是否删除，1=已删除，0=未删除
     */
    private Integer deleted;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 资料描述
     */
    private String resourceDesc;

    /**
     * 大图
     */
    private String resourceBigImg;

    /**
     * 资料外部链接
     */
    private String outLink;

    /**
     * 资料外部链接描述
     */
    private String outLinkDesc;

    /**
     * 资料图片，以英文逗号分隔
     */
    private String resourcePictures;

    /**
     * 资料类型
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.LiveInteractTypeEnum
     */
    private Integer resourceType;

    /**
     * 公众号二维码
     */
    private String oaQrCode;

    /**
     * 外链类型
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.OutLinkTypeEnum
     */
    private Integer outLinkType;

    /**
     * 外链appId 外链类型为小程序时需要传
     */
    private String outLinkAppId;

    /**
     * 按钮名称
     */
    private String resourceButtonTitle;

    /**
     * 描述
     */
    private String resourceSubTitle;

    /**
     * 表单头图
     */
    private String formBanner;

    /**
     * 贴片地址
     */
    private String pasterUrl;

    /**
     * 展示价格
     */
    private String showPrice;

    /**
     * 直播价,最低价
     */
    private Integer livePriceMin;

    /**
     * 直播价,最高价
     */
    private Integer livePriceMax;

    /**
     * 产品权益
     */
    private String productRights;

    /**
     * 商品主图 英文,分割
     */
    private String mainImages;

    /**
     * 营销配图 英文,分割
     */
    private String marketImages;

    /**
     * 商品详情图 英文,分割
     */
    private String detailImages;

    /**
     * 产品折扣
     */
    private Double productDiscount;

    /**
     * 产品标签 ,分割
     */
    private String productLabel;

    /**
     * 卡片名称
     */
    private String cardName;

    /**
     * 减免金额
     */
    private Integer reduceAmount;

    /**
     * 商品营销类型：1-普通商品2-半价商品 3-免费抢
     *
     * @see cn.com.duiba.kjy.livecenter.api.enums.goods.GoodsMarketTypeEnum
     */
    private Integer marketType;

    /**
     * 第二外部链接
     */
    private String extraOutLink;

    /**
     * 一些后面增加的额外信息，json形式存在这个字段
     * 不再额外增加别的字段
     * @see ResourceExtraInfoDto
     */
    private String extraInfo;

    /**
     * 营销标签配图
     */
    private String marketLabelImg;

    /**
     * 二级标签
     */
    private String subLabel;
}
