/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.livecenter.api.utils;

import cn.com.duiba.kjy.livecenter.api.bean.share.AgentShareBean;
import cn.com.duiba.kjy.livecenter.api.bean.share.LiveRoomShareBean;
import cn.com.duiba.kjy.livecenter.api.bean.share.ShareBean;
import cn.com.duiba.kjy.livecenter.api.enums.ShareTypeEnum;
import cn.com.duiba.wolf.utils.BlowfishUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class ShareUtils {
    private static final String SHARE_ENCRYPT = "89f1657ff6a3";

    private ShareUtils() {
    }

    public static <T extends ShareBean> String signShareBean(T bean) {
        if (Objects.isNull(bean)) {
            return null;
        }
        ShareTypeEnum shareTypeEnum = ShareTypeEnum.getByCode(bean.getShareType());
        if (shareTypeEnum == null) {
            return null;
        }
        try {
            return BlowfishUtils.encryptBlowfish((String)JSON.toJSONString(bean), (String)SHARE_ENCRYPT);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T extends ShareBean> T decodeShareSign(String sign, Class<T> clazz) {
        if (StringUtils.isBlank((CharSequence)sign) || "undefined".equals(sign) || StringUtils.equals((CharSequence)sign, (CharSequence)"null")) {
            return null;
        }
        try {
            String content = BlowfishUtils.decryptBlowfish((String)sign, (String)SHARE_ENCRYPT);
            JSONObject jsonObject = JSON.parseObject((String)content);
            ShareBean bean = (ShareBean)jsonObject.toJavaObject(clazz);
            if (bean == null) {
                return null;
            }
            ShareTypeEnum shareTypeEnum = ShareTypeEnum.getByCode(bean.getShareType());
            if (shareTypeEnum == null) {
                return null;
            }
            if (!shareTypeEnum.getCode().equals(jsonObject.getInteger("shareType"))) {
                return null;
            }
            return (T)bean;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void main(String[] args) {
        LiveRoomShareBean r = ShareUtils.decodeShareSign("51jH3nXRvakEb4uKTxvfzcSGecKtQ1Mauayc758RcaefyTUxWMQhnfBoiSKF6Lcam5sdZ83Ki4ic392JR1fcTt25bKgC1JhYSeie7CdfwpvgL3qRmM", LiveRoomShareBean.class);
        AgentShareBean r1 = ShareUtils.decodeShareSign("51jH3nXRvakEb4uKTxvfzcSGecKtQ1Mauayc758RcaefyTUxWMQhnfBoiSKF6Lcam5sdZ83Ki4ic392JR1fcTt25bKgC1JhYSeie7CdfwpvgL3qRmM", AgentShareBean.class);
        System.out.println(r);
        System.out.println(r1);
    }
}

