package cn.com.duiba.live.mall.api.dto.shopgoods;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 景点地址表
 * @author youqian mybatis generator 
 * 2021-04-19
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class GoodsAddressDto implements Serializable {
    private static final long serialVersionUID = 16188150418891444L;

    /**
     * 主键ID
     * not null default = null
     */
    private Long id;

    /**
     * 景区地址ID
     * not null default = 0
     */
    private Long goodsAddressId;

    /**
     * 货号ID
     * not null default = 0
     */
    private Long goodsId;

    /**
     * 景区景点名称
     * max length = 50
     * not null default = 
     */
    private String name;

    /**
     * 详细地址
     * not null default = 0
     */
    private Long address;

    /**
     * 纬度
     * not null default = 0.0000000
     */
    private BigDecimal latitude;

    /**
     * 经度
     * not null default = 0.0000000
     */
    private BigDecimal longitude;

    /**
     * 是否删除，0-未删除，其他-已删除
     * not null default = 0
     */
    private Byte deleteFlag;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}