package cn.com.duiba.live.mall.api.dto.shopgoods;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 规格属性值表
 * @author youqian mybatis generator 
 * 2020-06-11
 */
@Data
public class ShopSpecValueDto implements Serializable {
    private static final long serialVersionUID = 15918567972128310L;

    private Long id;

    /**
     * 唯一id
     * not null default = null
     */
    private Long shopSpecValueId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Boolean deleted;

    /**
     * 规格属性id
     * not null default = 0
     */
    private Long specParamId;

    /**
     * 属性值名称
     * max length = 30
     * not null default = null
     */
    private String name;

    /**
     * 显示排序
     * not null default = 0
     */
    private Integer displayOrder;

    /**
     * 商户号
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 服装商场的特殊需求，只要颜色和尺寸
     1代表颜色属性
     2代表尺寸属性
     0代表其他属性
     * not null default = 0
     */
    private Byte colorOrSize;
}