package cn.com.duiba.live.mall.api.dto.shopgoods.custom;

import cn.com.duiba.live.mall.api.dto.shopgoods.ShopGoodsDto;
import cn.com.duiba.live.mall.api.dto.shopgoods.ShopGoodsTagDto;
import cn.com.duiba.live.mall.api.dto.shopgoods.custom.picture.GoodsInfoPicDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * Created by hong
 * time 2020/10/23.
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class GoodsWholeInfoV2 extends ShopGoodsDto {

    private static final long serialVersionUID = -4414700838939151037L;

    /**
     * 商品图片集合
     */
    private List<GoodsInfoPicDto> shopGoodsPictureDtos;


    /**
     * 商品规格集合
     */
    private List<SkuDto> skus;

    /**
     * 商品标签集合
     */
    private List<ShopGoodsTagDto> shopGoodsTagDtos;

    /**
     * 是否收藏
     */
    private Boolean collect;

    /**
     * 是否询价
     */
    private Boolean enquiry;

    /**
     * 商户名称
     */
    private String merchantName;

}
