package cn.com.duiba.live.mall.api.exception;

import org.apache.commons.lang3.StringUtils;

import java.util.Collection;
import java.util.Map;

/**
 * Created by hong
 * time 2021/3/5.
 */
public abstract class BizChecker {
    public static void checkNotNull(Object o, ErrorCode
            code) throws BizException {
        if (o != null) {
            return;
        }
        throwException(code);
    }

    public static void checkIsTrue(boolean expression, ErrorCode code) throws BizException {
        if (expression) {
            return;
        }
        throwException(code);
    }

    public static void checkNotBlank(String test, ErrorCode code) throws BizException {
        if (StringUtils.isNotBlank(test)) {
            return;
        }
        throwException(code);
    }

    public static void checkGtZero(Number number, ErrorCode code) throws BizException {
        if (number != null) {
            if (number instanceof Integer && (Integer) number > 0) {
                return;
            }
            if (number instanceof Long && (Long) number > 0L) {
                return;
            }
            if (number instanceof Float && (Float) number > 0F) {
                return;
            }
            if (number instanceof Double && (Double) number > 0D) {
                return;
            }
        }
        throwException(code);
    }

    public static void checkNotEmpty(Collection collection, ErrorCode code) throws BizException {
        if (collection != null && collection.size() > 0) {
            return;
        }
        throwException(code);
    }

    public static void checkNotEmpty(Map map, ErrorCode code) throws BizException {
        if (map != null && map.size() > 0) {
            return;
        }
        throwException(code);
    }

    public static void throwException(ErrorCode code) throws BizException {
        throw new BizException(code.getDesc()).withCode(String.valueOf(code.getCode()));
    }
}
