package cn.com.duiba.live.mall.api.exception;

import cn.com.duibaboot.ext.autoconfigure.cat.CatRpcHandlerInterceptor;
import cn.com.duibaboot.ext.autoconfigure.cat.SpringMvcConfigForCat;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.feign.hystrix.FeignErrorDecoder;
import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.web.mvc.BizExceptionResolver;
import com.netflix.hystrix.HystrixCommand;
import feign.hystrix.HystrixFeign;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * Created by hong
 * time 2021/3/5.
 */
@Configuration
@ConditionalOnClass({FeignClient.class, HystrixCommand.class, HystrixFeign.class, FeignErrorDecoder.class, BizExceptionResolver.class, SpringMvcConfigForCat.class})
public class FeignExceptionConfiguration {

    @Bean
    public static BizExceptionResolverCustom bizExceptionResolverCustom() {
        return new BizExceptionResolverCustom();
    }

    @Bean
    public static SpecifiedBeanPostProcessor<FeignErrorDecoder> feignErrorDecoderPostProcessorConfigurer() {

        return new SpecifiedBeanPostProcessor<FeignErrorDecoder>() {

            @Override
            public int getOrder() {
                return -1;
            }

            @Override
            public Class<FeignErrorDecoder> getBeanType() {
                return FeignErrorDecoder.class;
            }

            @Override
            public Object postProcessBeforeInitialization(FeignErrorDecoder bean, String beanName) throws BeansException {
                return bean;
            }

            @Override
            public Object postProcessAfterInitialization(FeignErrorDecoder bean, String beanName) throws BeansException {
                return new FeignErrorDecoderCustom();
            }
        };
    }

    @Bean
    public static SpecifiedBeanPostProcessor<BizExceptionResolver> bizExceptionResolverPostProcessorConfigurer() {


        return new SpecifiedBeanPostProcessor<BizExceptionResolver>() {

            @Override
            public int getOrder() {
                return -1;
            }

            @Override
            public Class<BizExceptionResolver> getBeanType() {
                return BizExceptionResolver.class;
            }

            @Override
            public Object postProcessBeforeInitialization(BizExceptionResolver bean, String beanName) throws BeansException {
                return bean;
            }

            @Override
            public Object postProcessAfterInitialization(BizExceptionResolver bean, String beanName) throws BeansException {
                return bizExceptionResolverCustom();
            }
        };

    }
    @Bean
    public static SpecifiedBeanPostProcessor<CatRpcHandlerInterceptor> catRpcHandlerInterceptorConfigurer(@Value("${spring.application.name}") String springApplicationName) {

        return new SpecifiedBeanPostProcessor<CatRpcHandlerInterceptor>() {

            @Override
            public int getOrder() {
                return -1;
            }

            @Override
            public Class<CatRpcHandlerInterceptor> getBeanType() {
                return CatRpcHandlerInterceptor.class;
            }

            @Override
            public Object postProcessBeforeInitialization(CatRpcHandlerInterceptor bean, String beanName) throws BeansException {
                return bean;
            }

            @Override
            public Object postProcessAfterInitialization(CatRpcHandlerInterceptor bean, String beanName) throws BeansException {
                return new CatRpcCustomHandlerInterceptor(springApplicationName);
            }
        };

    }
}

