package cn.com.duiba.live.mall.api.params.goods;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import cn.com.duiba.live.mall.api.params.goods.spec.AddSkuSpecParamV1;
import cn.com.duiba.live.mall.api.util.BigDecimalDeserializer;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Created by hong
 * time 2020/10/22.
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class AddSkuParam implements Serializable {

    private static final long serialVersionUID = -212636563529206686L;

    /**
     * 库存
     */
    private Integer total;

    /**
     * 名称
     * max length = 100
     */
    private String name;

    /**
     * 商品规格码
     * max length = 255
     */
    private String goodsSpecCode;

    /**
     * 价格
     */
    @JsonDeserialize(using = BigDecimalDeserializer.class)
    private BigDecimal price=BigDecimal.ZERO;

    /**
     * 件规
     */
    private Integer totalSpec;

    /**
     * 是否选中
     */
    private Boolean selected;

    /**
     * 规格集合
     */
    private List<AddSkuSpecParamV1> specs=new ArrayList<>();

    //////////////////旅游商品补充

    /**
     * 库存数量
     */
    private Integer stockQuantity;


    /**
     * 计划数量
     */
    private Integer planQuantity;

    /**
     * 库存位
     */
    private Integer placeNum;

    /**
     * 销售价格
     */
    private BigDecimal salePrice;

    /**
     * 市场价格
     */
    private BigDecimal marketPrice;

    /**
     * 有截止日期的情况
     */
    private Date expireDate;

    /**
     * 返佣方式 1-返佣比例  2-返佣金额
     */
    private Byte returnType;

    /**
     * 返佣金额
     */
    private BigDecimal returnMoney;

    /**
     * 限制时间
     */
    private List<Date> disableDate;

}
