package cn.com.duiba.live.mall.api.params.goods;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import cn.com.duiba.live.mall.api.params.Operator;
import cn.com.duiba.live.mall.api.util.BigDecimalDeserializer;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author tengtuox
 * @date 2020/11/17
 * @description
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class AddSkuParamV2 extends Operator implements Serializable {

    /**
     * 商品ID
     */
    @NotNull(message = "商品ID不能为空")
    @Min(value = 1, message = "商品ID必须大于0")
    private Long shopGoodsId;

    /**
     * 商品规格码
     */
    private String goodsSpecCode;

    /**
     * 价格
     */
    @JsonDeserialize(using = BigDecimalDeserializer.class)
    private BigDecimal price = BigDecimal.ZERO;

    /**
     * 名称
     */
    private String name;

    /**
     * 颜色
     */
    private String color;

    /**
     * 尺码
     */
    private String size;
}
