package cn.com.duiba.live.mall.api.params.goods;

import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author xiachenhang
 */
@Data
public class GoodsActionParam  implements Serializable {

    /**
     * 商品ID
     */
    @Min(1)
    @NotNull(message = "商品Id不能为空")
    private Long goodsId;
    /**
     * 商户ID
     */
    @Min(1)
    @NotNull(message = "商户ID不能为空")
    private Long merchantId;
    /**
     * 用户ID
     */
    private Long userId;
    /**
     * 状态 1-确定 0-取消
     */
    private Integer status;
    /**
     * 来源
     */
    @NotNull(message = "来源不能为空")
    private Integer type;
    /**
     * 房间号ID
     */
    private Long liveRoomId;

    /**
     * 分享用户Id
     */
    private Long shareUserId;


}
