package cn.com.duiba.live.mall.api.params.goods;

import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

@Data
public class GoodsIntroductionParam  implements Serializable {

    /**
     * 商户ID
     */
    private long merchantId;


    /**
     * 商品ID 不可为空
     */
    @NotNull(message = "商品编号不能为空")
    @Min(value= 1,message = "商品编号最小为1")
    private long shopGoodsId;

    /**
     * 商品SKUID 可为空
     */
    @NotNull(message = "商品SKU编号不能为空")
    @Min(value= 0,message = "未知编号请填0")
    private long shopGoodsSkuId;

    /**
     * 详细介绍
     */
    @NotBlank(message = "商品介绍不能为空")
    private String introduction;
}
