package cn.com.duiba.live.mall.api.params.goods;

import cn.com.duiba.live.mall.api.params.PageParam;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * Created by hong
 * time 2020/6/11.
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class GoodsListGetParamV extends PageParam implements Serializable {

    private static final long serialVersionUID = -2590012957260039773L;

    /**
     * 标签id列表
     */
    private List<Long> tagIds;

    /**
     * 商品货号（短名称）
     */
    private String     shortName;

    /**
     * 上新
     */
    private Byte    newPublish;

    /**
     * 爆款
     */
    private Byte    hot;

    /**
     * 促销
     */
    private Byte    discount;

    /**
     * 商品id集合
     */
    private List<Long> goodsIds;

    private List<Byte> types;

    private List<Byte> saleStatus;

    /**
     * 公司id
     */
    private Long companyId;
}
