package cn.com.duiba.live.mall.api.params.goods;

import cn.com.duiba.live.mall.api.params.PageParam;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * Created by hong
 * time 2020/10/24.
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class GoodsListGetParamV2 extends PageParam implements Serializable {

    private static final long serialVersionUID = 7459639963746710444L;

    /**
     * 标签id列表
     */
    private List<Long> tagIds;

    /**
     * 商品名称
     */
    private String     name;

    /**
     * 商品货号（短名称）
     */
    private String     shortName;

    /**
     * 上新
     */
    private Byte    newPublish=(byte)0;

    /**
     * 爆款
     */
    private Byte    hot=(byte)0;

    /**
     * 促销
     */
    private Byte    discount=(byte)0;

    /**
     * 商品id集合
     */
    private List<Long> goodsIds;

    /**
     * 商户id
     */
    private Long merchantId;

    /**
     * 是否需要二次预约
     */
    private byte needOrder;

    /**
     * 有截止日期的情况 sku的描述，可为空
     */
    private Date expireDate;

    /**
     * 商户类型 0-  服装类企业  1-旅游类企业
     */
    private List<Byte> types;

    private List<Byte> saleStatus;
}
