package cn.com.duiba.live.mall.api.params.goods;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import cn.com.duiba.live.mall.api.dto.shopgoods.custom.spec.ColorAndSizeSpecDto;
import cn.com.duiba.live.mall.api.params.shoptag.GoodsTagRelationParam;
import cn.com.duiba.live.mall.api.util.BigDecimalDeserializer;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * Created by hong
 * time 2020/10/23.
 */
@Data
public class UpdateGoodsParam implements Serializable {

    private static final long serialVersionUID = 1640547978088990764L;

    /**
     * 商品id
     */
    private Long shopGoodsId;

    /**
     * 商品名
     */
    @NotBlank(message = "商品名不能为空")
    @Size(max = 50, min = 1, message = "商品名应为1-50位")
    private String goodsName;

    /**
     * 货号
     */
    @NotBlank(message = "货号不能为空")
    @Size(max = 20, min = 1, message = "货号应为1-20位")
    private String shortName;

    /**
     * 单位
     */
    private String unit;

    /**
     * 单价
     */
    @JsonDeserialize(using = BigDecimalDeserializer.class)
    private BigDecimal marketPrice=BigDecimal.ZERO;

    /**
     * 是否推荐  1是
     *
     * @see cn.com.duiba.live.mall.api.enums.TrueOrFalseEnum
     */
    private Integer recommend;

    /**
     * 是否上新 1是
     */
    private Byte newPublish;

    /**
     * 是否热卖  1是
     */
    private Byte hot;

    /**
     * 是否促销   1是
     */
    private Byte discount;

    /**
     * 标签数组
     */
    private List<GoodsTagRelationParam> tags;

    /**
     * 商品图片oss数组
     */
    private List<InsertPicBatchParam> goodsPics;

    /**
     * 规格操作参数数组
     */
    private List<UpdateSkuParam> skuParams;

    /**
     * 商户ID
     */
    private Long merchantId;

    /**
     * 是否需要二次预约
     */
    private byte needOrder;

    /**
     * 有截止日期的情况
     */
    private Date expireDate;

    /**
     * 富文本说明介绍
     * not null default = null
     */
    private String introduction;

    private Integer type;

    /**
     * 销售状态
     */
    private byte saleStatus;

    /**
     * 商品详情
     * 用于显示商品 短名称
     */
    private String content;

    /**
     * 商品描述
     * 用于显示 景点地址JSON
     */
    private String description;

    /**
     * 商品编号
     * 用于显示 商品标签
     */
    private String goodsSn;
}
