package cn.com.duiba.live.mall.api.remoteservice.express;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.mall.api.dto.express.ExpressTemplateDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;
import java.util.Map;

/**
 *
 * 加钱购运费模版service
 * 
 * @create 2015年12月24日 上午11:42:59
 * @author Hermit
 * @version
 */
@AdvancedFeignClient
public interface RemoteExpressTemplateService {

	/**
	 * 根据id查询
	 * 
	 * @param id
	 * @return
	 */
	public DubboResult<ExpressTemplateDto> find(Long id);

	/**
	 * 根据IDs查询
	 *
	 * @param ids
	 * @return
	 */
	List<ExpressTemplateDto> findList(List<Long> ids);

	/**
	 * 新增记录
	 * 
	 * @param entity
	 * @return
	 */
	public DubboResult<Long> insert(ExpressTemplateDto entity);

	/**
	 * 更新记录
	 * 
	 * @param entity
	 */
	public DubboResult<Integer> update(ExpressTemplateDto entity);

	/**
	 * 分页查询
	 * 
	 * @param params
	 * @return
	 */
	public DubboResult<List<ExpressTemplateDto>> findPageList(Map<String, Object> params);

	/**
	 * 统计条数
	 * 
	 * @param params
	 * @return
	 */
	public DubboResult<Long> findPageCount(Map<String, Object> params);

	/**
	 * 删除模版
	 * 
	 * @param id
	 * @return
	 */
	public DubboResult<Integer> deleteTemplateById(Long id);

	/**
	 * 根据APPID和类型查询
	 * 
	 * @param appId
	 * @param type
	 */
	public DubboResult<List<ExpressTemplateDto>> findByAppIdAndType(Long appId, String type);

	/**
	 * 根据APPID和名称查询
	 * 
	 * @param appId
	 * @param name
	 */
	public DubboResult<List<ExpressTemplateDto>> findByAppIdAndName(Long appId, String name);

	/**
	 * duiba后台查找模板
	 * @return
	 */
	List<ExpressTemplateDto> findDuibaExpressTemplate();

	/**
	 * duiba后台根据名字查找模板
	 * @return
	 */
	ExpressTemplateDto findExpressTemplateByName(String name);
}
