package cn.com.duiba.live.mall.api.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

@Data
@EqualsAndHashCode(callSuper = true)
public class OrderListRequestV5 extends PageRequest implements Serializable {

    /**
     *  通过 status 读取买家订单信息
     *
     * 0- 全部
     * 1- 待预约
     * 2- 待使用
     * 3- 待发货
     * 4- 待收货
     * 5- 已完成
     */
    /**
     * 订单状态
     */
    private Byte status;

    /**
     *用户ID
     */
    private Long userId;

    /**
     *商户ID
     */
    private Long companyId;

    /**
     *直播间编号
     */
    private Long liveRoomId;

}
