package cn.com.duiba.live.mall.api.request;



import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

@Data
@EqualsAndHashCode(callSuper = true)
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class OrderSearchRequestV5 extends PageRequest implements Serializable {

    /**
     * 商户ID
     */
    private Long merchantId;

    /**
     *订单状态
     */
    private Byte orderStatus;

    /**
     * 订单编号
     */
    private String orderNumber;

    /**
     *客户名称
     */
    private String customerName;

    /**
     * 客户手机号
     */
    private String customerMobile;

    /**
     *商品名称
     */
    private String goodsName;

    /**
     *开始时间
     */
    private Date startTime;

    /**
     *结束时间
     */
    private Date endTime;

    /**
     *买家ID
     */
    private Long userId;

    /**
     *直播间编号
     */
    private Long liveRoomId;

    /**
     *收付款状态
     */
    private Byte moneyReceiveType;

    /**
     *使用状态
     */
    private Byte useStatus;

    /**
     *订单类型
     */
    private Byte orderType;

    /**
     *订单是否取消
     */
    private Byte cancelStatus;

    /**
     *发货状态
     */
    private Byte deliverGoods;

    /**
     *查询关键字
     */
    private String searchValue;
}
