package cn.com.duiba.live.mall.api.response;

import cn.com.duiba.live.mall.api.util.BigDecimalSerializer;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author tengtuox
 * @date 2020/4/7
 * @description
 */
@Data
public class OrderDetail implements Serializable {

    /**
     * 订单ID
     */
    private Long orderId;

    /**
     * 订单编号
     */
    private String orderNumber;

    /**
     * 商品总额
     */
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal goodsPrice;

    /**
     * （原价）订单总额=商品总额+运费+税费等等
     */
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal originOrderPrice;

    /**
     * 订单总额折后价：应付款
     */
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal totalPrice;

    /**
     * 优惠劵优惠金额
     */
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal reducePrice;

//    /**
//     * 已收款金额
//     */
//    @JsonSerialize(using = BigDecimalSerializer.class)
//    private BigDecimal receivePrice;
//
//    /**
//     * 待收款金额
//     */
//    @JsonSerialize(using = BigDecimalSerializer.class)
//    private BigDecimal restPrice;

    /**
     * 订单状态
     */
    private Byte orderStatus;

    /**
     * 订单状态文字
     */
    private String orderStatusText;

    /**
     * 订单确认状态,0-未确认/1-已确认
     */
    private Integer confirmStatus;

    /**
     * 发货状态
     */
    private Byte deliverGoods;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 订单确认时间
     */
    private Date confirmTime;

    /**
     * 发货时间
     */
    private Date deliveryTime;

    /**
     * 是否是买家
     */
    private Byte buyer;
    /**======OrderExt=====*/
    /**
     * 运费
     */
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal transportFee;

    /**
     * 收货人名称
     */
    private String receiverName;

    /**
     * 收货人手机号码
     */
    private String receiverMobile;

    /**
     * 收货地址
     */
    private String receiverAddress;

//    @ApiModelProperty("省代码")
//    private String provinceCode;
//
//    @ApiModelProperty("市代码")
//    private String cityCode;
//
//    @ApiModelProperty("区代码")
//    private String areaCode;

    /**
     * 详细地址
     */
    private String detailArea;

    /**
     * 运费支付方式,1-预付/2-包邮/3-到付
     */
    private Byte transportFeeType;

    /*@ApiModelProperty("省文本")
    private String province;

    @ApiModelProperty("市文本")
    private String city;*/

    /**=====Goods=====*/
    /**
     * 商品详情
     */
    private List<OrderItemDetail> goodsList;

    /**
     * 商品总数
     */
    private Integer goodsNum = 0;

    /**=====Button====*/
//    @ApiModelProperty("是否有发起合同按钮")
//    private Boolean createContractButton = Boolean.FALSE;
//
//    @ApiModelProperty("是否有录入收款按钮")
//    private Boolean moneyBackButton = Boolean.FALSE;
//
//    @ApiModelProperty("是否有我发货了按钮")
//    private Boolean deliverGoodsButton = Boolean.FALSE;
//
//    @ApiModelProperty("是否有发送给客户按钮")
//    private Boolean sendCustomerButton = Boolean.FALSE;
//
//    @ApiModelProperty("是否有购销合同按钮")
//    private Boolean contractButton = Boolean.FALSE;
//
//    @ApiModelProperty("是否有收款记录按钮")
//    private Boolean moneyBackHisButton = Boolean.FALSE;
//
//    @ApiModelProperty("是否有确认订单按钮")
//    private Boolean confirmButton = Boolean.FALSE;
//
//    @ApiModelProperty("是否有取消订单按钮")
//    private Boolean cancelButton = Boolean.FALSE;
//
//    @ApiModelProperty("是否有返回首页按钮")
//    private Boolean returnTopButton = Boolean.FALSE;
//
//    @ApiModelProperty("是否有修改订单按钮")
//    private Boolean modifyButton = Boolean.FALSE;
//
//    @ApiModelProperty("订单回款列表")
//    private List<OrderMoneyBackDto> orderMoneyBackDto;
//
//    @ApiModelProperty("订单编号")

//    @ApiModelProperty("订单备注")
//    /**
//     * 订单备注
//     */
//    private String orderRemark;

    /**============其他信息==============*/
//    @ApiModelProperty("是否是销售商户")
//    private Boolean sellerMerchant;

    /**============其他补充信息==============*/
//    @ApiModelProperty("订单类型")
//    private Byte orderType;
//
//    @ApiModelProperty("使用状态")
//    private Byte useStatus;
//
//    @ApiModelProperty("取消状态")
//    private Byte cancelStatus;
//
//    @ApiModelProperty("分享人编号")
//    private Long shareUserId;
//
//    @ApiModelProperty("分享人名称")
//    private String shareUserName;
//
//    @ApiModelProperty("直播间编号")
    /**
     * 直播间编号
     */
    private Long liveRoomId;

//    @ApiModelProperty("返回佣金")
//    private BigDecimal returnMoney;

//    @ApiModelProperty("商品编号")
//    private Long goodsId;
//
    /**
     * 商品缩略图
     */
    private String goodsThumb;

//    @ApiModelProperty("预约通知模板ID")
//    private String reserveTemplateId;

//    /**
//     * 商品类型
//     */
//    private Byte goodsType;

//    private EmployeeInfo employeeInfo;

}
