package cn.com.duiba.live.mall.api.response;

import cn.com.duiba.live.mall.api.util.BigDecimalSerializer;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author tengtuox
 * @date 2020/3/26
 * @description
 */
@Data
public class OrderPageResult implements Serializable {

    /**
     * 订单ID
     */
    private Long orderId;

    /**
     * 订单编号
     */
    private String orderNumber;

//    /**
//     * 卖（买）家头像
//     */
//    private String avatarUrl;
//
//    /**
//     * （买）家名称（收货人）
//     */
//    private String name;
//
//    /**
//     * （买）家手机号：收货人手机号
//     */
//    private String mobilePhone;
//
//    @ApiModelProperty("公司名称/商户名称")
//    private String companyName;
//
//    @ApiModelProperty("开单人")
//    private String createUserName;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 订单状态
     */
    private Byte orderStatus;

    /**
     * 订单状态文字
     */
    private String orderStatusText;

    /**
     * 运费
     */
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal transportFee;

    /*@ApiModelProperty("税费")
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal tax;*/

    /**
     * 实付款
     */
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal totalPrice;

    /**
     * 优惠劵优惠金额
     */
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal reducePrice;

    /**
     * （原价）订单总额=商品总额+运费+税费等等
     */
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal originOrderPrice;

//    @ApiModelProperty("待收款金额")
//    @JsonSerialize(using = BigDecimalSerializer.class)
//    private BigDecimal toCheckBillPrice;

    /**
     * 商品列表
     */
    private List<OrderItemDetail> goodsList;

    /**
     * 订单确认时间
     */
    private Date confirmTime;

    /**
     * 发货时间（操作发货时间）
     */
    private Date deliveryTime;

//    @ApiModelProperty("运输方式， 1-卖家送货/2-买家自提")
//    private Byte transType;

    /**
     * 收货人名称
     */
    private String receiverName;

    /**
     * 收货人手机号码
     */
    private String receiverMobile;

    /**
     * 收货地址
     */
    private String receiverAddress;

//    @ApiModelProperty("提货人")
//    private String deliveryName;
//
//    @ApiModelProperty("提货人手机号码")
//    private String deliveryMobile;
//
//    @ApiModelProperty("提货地址")
//    private String deliveryAddress;
//
//    /**
//     * 订单备注
//     */
//    private String orderRemark;
//
//    @ApiModelProperty("订单类型")
//    private Byte orderType;

//    @ApiModelProperty("使用状态")
//    private Byte useStatus;

    /**
     * 取消状态: 0-正常；1:自动取消；2:手动取消；3:审核拒绝
     */
    private Byte cancelStatus;

//    @ApiModelProperty("分享人编号")
//    private Long shareUserId;
//
//    @ApiModelProperty("分享人名称")
//    private String shareUserName;

    /**
     * 直播间编号
     */
    private Long liveRoomId;

//    /**
//     * 商品编号
//     */
//    private Long goodsId;
//
//    /**
//     * 商品缩略图
//     */
//    private String goodsThumb;

}
