package cn.com.duiba.live.mall.api.response;

import cn.com.duiba.live.mall.api.request.PageRequest;
import lombok.Data;
import org.apache.commons.collections4.CollectionUtils;

import java.io.Serializable;
import java.util.List;

/**
 * @author tengtuox
 * @date 2020/1/3
 * @description 分页结果
 */
@Data
public class PageResult<T> implements Serializable {

    private static final long serialVersionUID = 3500044282124584159L;

    /**
     * 分页数据
     */
    private List<T> list;

    /**
     *页码
     */
    private Integer pageNo;

    /**
     *页大小
     */
    private Integer pageSize;

    /**
     *是否有下一页
     */
    private Boolean hasNext;

    /**
     *总共条数
     */
    private Long total = 0L;

    /**
     *总页数
     */
    private Integer totalPageNo = 0;

    public static <T> PageResult<T> create(List<T> data, Integer pageNo, Integer pageSize, Long total) {
        PageResult<T> pageResult = new PageResult<>();
        pageResult.setList(data);
        pageResult.setPageNo(pageNo);
        pageResult.setPageSize(pageSize);
        pageResult.setTotal(total);
        if (CollectionUtils.isEmpty(data)) {
            pageResult.setHasNext(false);
        } else {
            if (pageSize > data.size()) {
                pageResult.setHasNext(false);
            } else {
                pageResult.setHasNext(true);
            }
        }
        long totalPageNo = (total % pageSize == 0) ? total / pageSize : (total / pageSize + 1);
        pageResult.setTotalPageNo((int) totalPageNo);
        return pageResult;
    }

    public static <T> PageResult<T> create(List<T> data, PageRequest pageRequest, Long total) {
        return create(data, pageRequest.getPageNo(), pageRequest.getPageSize(), total);
    }
}
