package cn.com.duiba.live.mall.api.dto.order;

import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 订单付款
 * @author youqian mybatis generator 
 * 2021-03-31
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class OrderPayDto implements Serializable {
    private static final long serialVersionUID = 16171845591713921L;

    /**
     * 主键ID
     * not null default = null
     */
    private Long id;

    /**
     * 订单ID
     * not null default = 0
     */
    private Long orderId;

    /**
     * 订单号
     * max length = 100
     * not null default = null
     */
    private String orderNumber;

    /**
     * 返回信息 : 返回信息，如非空，为错误原因签名失败
     * max length = 20
     * not null default = null
     */
    private String realIp;

    /**
     * 返回状态码 : SUCCESS/FAIL 此字段是通信标识，非交易标识，交易是否成功需要查看result_code来判断
     * max length = 32
     * not null default = null
     */
    private String returnCode;

    /**
     * 返回信息 : 返回信息，如非空，为错误原因签名失败
     * max length = 128
     * not null default = null
     */
    private String returnMsg;

    /**
     * 小程序ID : 微信分配的小程序ID
     * max length = 32
     * not null default = null
     */
    private String appid;

    /**
     * 商户号 : 微信支付分配的商户号
     * max length = 32
     * not null default = null
     */
    private String mchId;

    /**
     * 设备号 : 微信支付分配的终端设备号
     * max length = 32
     * not null default = null
     */
    private String deviceInfo;

    /**
     * 随机字符串 : 随机字符串，不长于32位
     * max length = 32
     * not null default = null
     */
    private String nonceStr;

    /**
     * 签名
     * max length = 32
     * not null default = null
     */
    private String sign;

    /**
     * 签名类型 : 签名类型，目前支持HMAC-SHA256和MD5，默认为MD5
     * max length = 32
     * not null default = null
     */
    private String signType;

    /**
     * 业务结果 : SUCCESS/FAIL
     * max length = 16
     * not null default = null
     */
    private String resultCode;

    /**
     * 错误代码 : 错误返回的信息描述
     * max length = 32
     * not null default = null
     */
    private String errCode;

    /**
     * 错误代码描述 : 错误返回的信息描述
     * max length = 128
     * not null default = null
     */
    private String errCodeDes;

    /**
     * 用户标识 : 用户在商户appid下的唯一标识
     * max length = 128
     * not null default = null
     */
    private String openid;

    /**
     * 是否关注公众账号 : 用户是否关注公众账号，Y-关注，N-未关注
     * max length = 1
     * not null default = null
     */
    private String isSubscribe;

    /**
     * 交易类型 : JSAPI、NATIVE、APP
     * max length = 16
     * not null default = null
     */
    private String tradeType;

    /**
     * 付款银行 : 银行类型，采用字符串类型的银行标识，
     * max length = 32
     * not null default = null
     */
    private String bankType;

    /**
     * 订单金额 : 订单总金额，单位为分
     * not null default = 0
     */
    private Long totalFee;

    /**
     * 应结订单金额 : 应结订单金额=订单金额-非充值代金券金额，应结订单金额<=订单金额
     * not null default = 0
     */
    private Long settlementTotalFee;

    /**
     * 货币种类 : 货币类型，符合ISO4217标准的三位字母代码，默认人民币：CNY
     * max length = 8
     * not null default = null
     */
    private String feeType;

    /**
     * 现金支付金额 : 现金支付金额订单现金支付金额
     * not null default = 0
     */
    private Long cashFee;

    /**
     * 现金支付货币类型 : 货币类型，符合ISO4217标准的三位字母代码，默认人民币：CNY
     * max length = 16
     * not null default = null
     */
    private String cashFeeType;

    /**
     * 微信支付订单号
     * max length = 32
     * not null default = null
     */
    private String transactionId;

    /**
     * 商户订单号 : 商户系统内部订单号，要求32个字符内，只能是数字、大小写字母_-|*@ ，且在同一个商户号下唯一
     * max length = 32
     * not null default = null
     */
    private String outTradeNo;

    /**
     * 商家数据包，原样返回
     * max length = 128
     * not null default = null
     */
    private String attach;

    /**
     * 支付完成时间，格式为yyyyMMddHHmmss，如2009年12月25日9点10分10秒表示为20091225091010
     * max length = 14
     * not null default = null
     */
    private String timeEnd;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}