package cn.com.duiba.live.mall.api.enums.goods;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * 商品是否推荐枚举
 * Created by hong
 * time 2020/4/12.
 */
@Getter
public enum Recommend {
    YES((byte)1,"yes","推荐商品"),
    NO((byte)0,"no","不是推荐商品")
    ;

    private final Byte code;

    private final String type;

    private final String desc;

    Recommend(Byte code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public static Recommend getByCode(Byte code) {
        return Stream.of(Recommend.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(NO);
    }

    public static Recommend getByType(String type) {
        return Stream.of(Recommend.values()).filter(e -> e.getType().equals(type)).findFirst().orElse(NO);
    }
}

