package cn.com.duiba.live.mall.api.enums.order;

import lombok.Getter;

/**
 * @Author: fss
 * @Date: 2021/8/6 09
 * @Description: 订单取消状态
 */
@Getter
public enum EnumOrderCancelStatus {
    NORMAL((byte) 0, "正常"),
    AUTO_CANCEL((byte) 1, "自动取消(超时未付款)"),
    HAND_CANCEL((byte) 2, "手动取消"),
    CHECK_CANCEL((byte) 3, "审核拒绝"),
    ;

    EnumOrderCancelStatus(byte code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    private final byte code;
    private final String msg;

    public static EnumOrderCancelStatus get(Byte code) {
        for (EnumOrderCancelStatus cancelStatus : values()) {
            if (cancelStatus.getCode() == code) {
                return cancelStatus;
            }
        }
        return NORMAL;
    }
}
