package cn.com.duiba.live.mall.api.enums.order;

import lombok.Getter;

@Getter
public enum EnumUseStatus {

    WAIT_ORDER((byte) 0, "待预约"),
    HAVE_ORDER((byte) 1, "有预约"),
    WAIT_USE((byte) 3, "待使用"),
    HAVE_USE((byte) 4, "有使用"),
    USE_FINISH((byte) 5, "已使用"),
    ;

    EnumUseStatus(byte code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    private final byte code;
    private final String msg;

    public static EnumUseStatus get(Byte code){
        for(EnumUseStatus useStatus:values()){
            if(useStatus.getCode() == code){
                return useStatus;
            }
        }
        return WAIT_USE;
    }

}
