package cn.com.duiba.live.mall.api.exception;

/**
 * @author tengtuox
 * @date 2019/12/27
 * @description: 请求外部接口出现异常
 */
public class RemoteException extends RuntimeException {
    private static final long serialVersionUID = 4788366603876739985L;

    private Integer httpCode;

    public RemoteException(String message) {
        super(message);
    }

    public RemoteException(Integer httpCode, String message) {
        super(message);
        this.httpCode = httpCode;
    }

    public RemoteException(Integer httpCode, String message, Throwable cause) {
        super(message, cause);
        this.httpCode = httpCode;
    }

    public RemoteException(Integer httpCode, Throwable cause) {
        super(cause);
        this.httpCode = httpCode;
    }

    public Integer getHttpCode() {
        return httpCode;
    }
}
