package cn.com.duiba.live.mall.api.params.goods;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import cn.com.duiba.live.mall.api.params.shoptag.GoodsTagRelationParam;
import cn.com.duiba.live.mall.api.util.BigDecimalDeserializer;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 添加商品参数
 * Created by hong
 * time 2020/6/16.
 */
@Data
public class  AddGoodsParam implements Serializable {

    private static final long            serialVersionUID = 8202190481954588642L;

    /**
     * 商品名
     */
    @NotBlank(message = "商品名不能为空")
    @Size( max= 20,min = 1,message = "商品名应为1-20位")
    private String                       goodsName;

    /**
     * 货号
     */
    @NotBlank(message = "货号不能为空")
    @Size( max= 20,min = 1,message = "货号应为1-20位")
    private String                       shortName;

    /**
     * 是否推荐  1是
     * @see cn.com.duiba.live.mall.api.enums.TrueOrFalseEnum
     */
    private Integer                      recommend;

    /**
     * 单位
     */
    private String unit;

    /**
     * 单价
     */
    @JsonDeserialize(using = BigDecimalDeserializer.class)
    private BigDecimal marketPrice;

    /**
     * 是否上新 1是
     */
    private Byte newPublish;

    /**
     * 是否热卖  1是
     */
    private Byte hot;

    /**
     * 是否促销   1是
     */
    private Byte discount;

    /**
     * 标签数组
     */
    private List<GoodsTagRelationParam>  tags;

    /**
     * 商品图片oss数组
     */
    private List<InsertPicBatchParam>    goodsPics;

    /**
     * 规格操作参数数组
     */
    private List<AddSkuSpecParam>        colorAndSizeSpecDtos;

    /**
     * 商品id集合(商品删除用)
     */
    private List<Long>                   goodsIds;

    /**
     * 商户ID
     */
    private Long merchantId;

    /**
     * 用户ID
     */
    private Long userId;
}
