package cn.com.duiba.live.mall.api.params.order;

import cn.com.duiba.live.mall.api.params.PageParam;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * 获取需要回款的订单参数
 * Created by hong
 * time 2020/4/13.
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class DunningOrderParam extends PageParam {

    private static final long serialVersionUID = 3166952581139398294L;

    /**
     * 客户id
     */
    private Long customerId;

    /**
     * 商户id
     */
    private Long merchantId;

    /**
     * 回款单id
     */
    private Long dunningBillId;

    /**
     * 订单id集合
     */
    private List<Long> orderId;

    /**
     * 订单状态
     */
    private List<Integer> moneyReceiveType;
}
