package cn.com.duiba.live.mall.api.remoteservice.order;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.mall.api.exception.BizException;
import cn.com.duiba.live.mall.api.params.order.OrderRefundMoneyCheckParam;
import cn.com.duiba.live.mall.api.params.order.OrderRefundMoneyPayParam;
import cn.com.duiba.live.mall.api.request.OrderRefundMoneyPageRequest;
import cn.com.duiba.live.mall.api.response.OrderRefundMoneyPageResult;
import cn.com.duiba.live.mall.api.response.PageResult;


@AdvancedFeignClient
public interface RemoteOrderRefundService {

    /**
     * 员工对订单申请退款审核的操作
     * @param param
     * @return
     */
    boolean doOrderRefundMoney(OrderRefundMoneyCheckParam param) throws BizException;

    /**
     * 员工发出指令，进行退款操作
     * @param param
     * @return
     */
    boolean payRefundMoney(OrderRefundMoneyPayParam param) throws BizException;

    /**
     * 退款记录分页查询
     * @param request
     * @return
     */
    PageResult<OrderRefundMoneyPageResult> listByPage(OrderRefundMoneyPageRequest request) throws BizException;

}
