package cn.com.duiba.live.mall.api.request;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import java.io.Serializable;
import java.util.Date;

/**
 * @author fss
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class OrderSearchRequestV5 extends PageRequest implements Serializable {

    /**
     * 商户ID
     */
    private Long companyId;

    /**
     * 状态：
     * 0- 全部
     * 1- 待审核
     * 2- 待发货
     * 3- 待收货
     * 4- 已完成
     */
    private Byte status;

    /**
     * 订单ID
     */
    private String orderId;

    /**
     * 订单编号
     */
    private String orderNumber;

    /**
     * 客户名称
     */
    private String customerName;

    /**
     * 客户手机号
     */
    private String customerMobile;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 直播间编号
     */
    private Long liveRoomId;

}
