package cn.com.duiba.live.mall.api.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 订单发货
 *
 * @author fss
 */
@Data
@EqualsAndHashCode()
public class OrderSendRequest implements Serializable {

    /**
     * 订单ID
     */
    @Min(1)
    @NotNull
    private Long orderId;

    /**
     * 物流公司
     */
    @NotNull
    private String expressName;

    /**
     * 物流单号
     */
    @NotNull
    private String expressNumber;

}
