package cn.com.duiba.live.mall.api.dto.express;

import lombok.Data;

import java.io.Serializable;

/**
 * 快递信息 Created by xiaoxuda on 2016/12/22.
 */
@Data
public class ExpressInfoDto implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = -4714524638663725866L;
    /**
     * 收货表主键id
     */
    public static final String ID = "id";
    /**
     * 姓名
     */
    public static final String ADDR_NAME = "addrName";
    /**
     * 电话
     */
    public static final String ADDR_PHONE = "addrPhone";
    /**
     * 省份
     */
    public static final String ADDR_PROVINCE = "addrProvince";
    /**
     * 城市
     */
    public static final String ADDR_CITY = "addrCity";
    /**
     * 地区
     */
    public static final String ADDR_AREA = "addrArea";
    /**
     * 详细地址
     */
    public static final String ADDR_DETAIL = "addrDetail";

    /**
     * 街道地址
     */
    public static final String ADDR_STREET = "addrStreet";
    /**
     * 地址编码
     */
    public static final String ADDR_CODE = "addrCode";
    /**
     * 1 表示设置为默认地址 0 不设置为默认地址，仅入库
     */
    public static final String ISDEFAULTADDR = "isDefaultAddr";

    /**
     * 地址信息是否有效（完整性）,有效则直接可用，否则需要用户重新补全信息
     */
    private boolean addrValid = true;
    /**
     * 发/收货人姓名
     */
    private String addrName;
    /**
     * 发/收货人电话
     */
    private String addrPhone;
    /**
     * 省份名称
     */
    private String addrProvince;
    /**
     * 市名称
     */
    private String addrCity;
    /**
     * 县名称
     */
    private String addrArea;
    /**
     * 详细地址
     */
    private String addrDetail;
    /**
     * 街道地址
     */
    private String addrStreet;
    /**
     * 地址code
     */
    private String addrCode;
}
