package cn.com.duiba.live.mall.api.dto.order;

import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 客户收货地址
 * @author youqian mybatis generator 
 * 2020-11-16
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class CustomerAddressDto implements Serializable {
    private static final long serialVersionUID = 16054982074186342L;

    /**
     * 用户地址ID
     * not null default = 0
     */
    private Long customerAddressId;

    /**
     * 商户ID
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 客户ID
     * not null default = 0
     */
    private Long customerId;

    /**
     * 收货人名称
     * max length = 100
     * not null default = 
     */
    private String receiverName;

    /**
     * 收货人手机号码
     * max length = 20
     * not null default = 
     */
    private String receiverMobile;

    /**
     * 收货地址
     * max length = 1000
     * not null default = 
     */
    private String receiverAddress;

    /**
     * 地址类型，1-收货地址/2-提货地址
     * not null default = 0
     */
    private Byte addressType;

    /**
     * 省
     * max length = 10
     * not null default = 
     */
    private String provinceCode;

    /**
     * 市
     * max length = 10
     * not null default = 
     */
    private String cityCode;

    /**
     * 区
     * max length = 10
     * not null default = 
     */
    private String areaCode;

    /**
     * 省市区简称
     * max length = 30
     * not null default = 
     */
    private String shortAddress;

    /**
     * 是否删除，0-未删除，其他-已删除
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}